#include <iostream>
#include <vector>
#include <algorithm>

using namespace std;

struct Ponco {
    int w, v;
    int pocetni_indeks;
    double vrednost_po_jedinici_tezine;

    Ponco() {}

    Ponco(int _pocetni_indeks, int _w, int _v) {
        pocetni_indeks = _pocetni_indeks;
        w = _w;
        v = _v;
        vrednost_po_jedinici_tezine = 1.0d * v / w;
    }

    bool operator<(const Ponco& p) {
        return vrednost_po_jedinici_tezine < p.vrednost_po_jedinici_tezine;
    }
};

int main()
{
    int N, W;
    double e, korigovano_W;

    cin >> N >> W >> e;

    korigovano_W = (1.0d - e) * W;

    int w, v;
    vector<Ponco> ponco(N);

    for (int i = 0; i < N; i++) {
        cin >> w >> v;
        ponco[i] = Ponco(i, w, v);
    }

    sort(rbegin(ponco), rend(ponco));
    /*
    for (int i = 0; i < N; i++) {
        cout << (i + 1) << ". ponco: pocetni indeks " << (ponco[i].pocetni_indeks + 1) << ", w = " << ponco[i].w << ". v = " << ponco[i].v << ". vrednost_po_jedinici_tezine = " << ponco[i].vrednost_po_jedinici_tezine << endl;
    }
    */

    int ukupno_w = 0;
    vector<Ponco> kupljeni(0);

    for (int i = 0; i < N; i++) {
        if (ukupno_w + ponco[i].w > W) continue;

        kupljeni.emplace_back(ponco[i]);
        ukupno_w += ponco[i].w;

        if (1.0d * ukupno_w >= korigovano_W) break;

        if (ukupno_w == W) break;
    }

    int broj_kupljenih = kupljeni.size();
    cout << broj_kupljenih << endl;

    for (int i = 0; i < broj_kupljenih; i++) {
        cout << (kupljeni[i].pocetni_indeks + 1);
        if (i < broj_kupljenih - 1) cout << " ";
    }

    return 0;
}